IF NOT EXISTS (
    SELECT * FROM INFORMATION_SCHEMA.TABLES
    WHERE TABLE_NAME = 'PDV_VD_IT_LINX_INTEGRACAO'
)
BEGIN
    CREATE TABLE [dbo].[PDV_VD_IT_LINX_INTEGRACAO] (
        [CD_EMP] BIGINT NOT NULL DEFAULT 0,
        [CD_FILIAL] BIGINT NOT NULL DEFAULT 0,
        [CD_IT] BIGINT NOT NULL DEFAULT 0,
        [CD_PROD] BIGINT NOT NULL DEFAULT 0,
        [CD_VD] BIGINT NOT NULL DEFAULT 0,
		[QT_DESC_ITEM] BIGINT NOT NULL DEFAULT 0,
        [EAN] VARCHAR(20) COLLATE SQL_Latin1_General_CP1_CI_AS NULL DEFAULT '',
        [PRODUTO_DESCRICAO] VARCHAR(200) COLLATE SQL_Latin1_General_CP1_CI_AS NULL DEFAULT '',
        [VALOR_ITEC] MONEY NOT NULL DEFAULT 0,
        [VALOR_APLICADO_INTEGRACAO] MONEY NOT NULL DEFAULT 0,
        [INTEGRACAO] VARCHAR(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL DEFAULT '',		
        [ID_PROMOCAO] VARCHAR(50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL DEFAULT '',
        [COD_BIN] varchar(50)  COLLATE SQL_Latin1_General_CP1_CI_AS NULL DEFAULT '',		
        CONSTRAINT [PK_PDV_VD_IT_LINX_INTEGRACAO] PRIMARY KEY CLUSTERED 
        (
            [CD_EMP] ASC,
            [CD_FILIAL] ASC,
            [CD_VD] ASC,
            [CD_IT] ASC
        )
        WITH (
            PAD_INDEX = OFF,
            STATISTICS_NORECOMPUTE = OFF,
            IGNORE_DUP_KEY = OFF,
            ALLOW_ROW_LOCKS = ON,
            ALLOW_PAGE_LOCKS = ON
        ) ON [PRIMARY]
    ) ON [PRIMARY]


END
GO


